<?php
// Filename: bot.php
require_once 'config.php';
require_once 'includes/db_connect.php';
require_once 'includes/functions.php';
require_once 'includes/game_logic.php';
require_once 'includes/turn_engine.php'; 

$content = file_get_contents("php://input");
$update = json_decode($content, true);

if (!$update) exit;

$chat_id = $update['message']['chat']['id'] ?? $update['callback_query']['message']['chat']['id'];
$user_id = $update['message']['from']['id'] ?? $update['callback_query']['from']['id'];
$text = $update['message']['text'] ?? '';
$callback = $update['callback_query']['data'] ?? '';

// ---------------------------------------------------------
// 1. بررسی وضعیت ثبت‌نام
// ---------------------------------------------------------
$check = $conn->query("SELECT * FROM players WHERE user_id = $user_id");

// الف) کاربر کاملاً جدید است
if ($check->num_rows == 0) {
    initPlayer($user_id); // ساخت رکورد اولیه
    sendMessage($chat_id, "👋 به دنیای **«قلمروهای درگیر»** خوش آمدید!\n\nبرای تأسیس امپراتوری خود، لطفاً **نام فرمانروایی** خود را وارد کنید:");
    exit;
}

// دریافت اطلاعات کاربر
$player = $check->fetch_assoc();

// ب) کاربر در مرحله انتخاب نام است (capital_x هنوز 0 است)
if ($player['capital_x'] == 0) {
    if (!empty($text) && strpos($text, '/') !== 0) { // اگر متن است و دستور نیست
        $info = completeRegistration($user_id, $text);
        
        $msg = "✅ ثبت‌نام تکمیل شد فرمانده **{$info['name']}**!\n\n";
        $msg .= "🏰 پایتخت شما در مختصات **({$info['x']}, {$info['y']})** بنا شد.\n";
        $msg .= "📦 منابع اولیه و ارتش محافظ به شما تعلق گرفت.\n\n";
        $msg .= "اکنون می‌توانید از منوی زیر بازی را شروع کنید:";
        
        sendMessage($chat_id, $msg, [
            'keyboard' => [
                [['text'=>'🗺 نقشه'], ['text'=>'🏰 شهر']], 
                [['text'=>'⚔️ ارتش'], ['text'=>'🤝 دیپلماسی']],
                [['text'=>'💰 منابع'], ['text'=>'🏆 رتبه‌بندی']]
            ], 
            'resize_keyboard' => true
        ]);
    } else {
        sendMessage($chat_id, "لطفاً فقط نام خود را تایپ کرده و ارسال کنید:");
    }
    exit;
}

// ---------------------------------------------------------
// 2. دستورات ادمین
// ---------------------------------------------------------
if (defined('ADMIN_USER_ID') && $user_id == ADMIN_USER_ID) {
    if ($text == '/force' || $text == '/nextturn') {
        sendMessage($chat_id, "⏳ ...");
        $log = executeTurn();
        sendMessage($chat_id, "✅ نوبت انجام شد!\n\n" . $log);
        exit;
    }
    if ($text == '/res') {
        $conn->query("UPDATE player_resources SET food=10000, wood=10000, stone=10000, gold=50000 WHERE user_id=$user_id");
        sendMessage($chat_id, "🤑 منابع فول شد.");
        exit;
    }
    if ($text == '/resetmp') {
        $conn->query("UPDATE generals SET mp = max_mp");
        sendMessage($chat_id, "🏃‍♂️ انرژی پر شد.");
        exit;
    }
}

// ---------------------------------------------------------
// 3. بازی اصلی (برای کاربران ثبت‌نام شده)
// ---------------------------------------------------------

// منوی اصلی
if ($text == '/start') {
    sendMessage($chat_id, "فرمانده {$player['username']}، خوش برگشتید.", [
        'keyboard' => [
            [['text'=>'🗺 نقشه'], ['text'=>'🏰 شهر']], 
            [['text'=>'⚔️ ارتش'], ['text'=>'🤝 دیپلماسی']],
            [['text'=>'💰 منابع'], ['text'=>'🏆 رتبه‌بندی']]
        ], 
        'resize_keyboard' => true
    ]);
}

// مسیریابی دستورات متنی
elseif ($text == '🗺 نقشه' || $text == '/map') {
    handleShowMap($user_id, $chat_id, $player['capital_x'], $player['capital_y']);
}
elseif ($text == '⚔️ ارتش' || $text == '/army') {
    handleArmyMenu($user_id, $chat_id);
}
elseif ($text == '🏰 شهر' || $text == '/city') {
    handleCityMenu($user_id, $chat_id); 
}
elseif ($text == '🤝 دیپلماسی' || $text == '/diplomacy') {
    handleDiplomacyMenu($user_id, $chat_id);
}
elseif ($text == '🏆 رتبه‌بندی' || $text == '/rank') {
    handleRanking($user_id, $chat_id);
}
// گزارش منابع (اصلاح شده با نرخ تولید)
elseif ($text == '💰 منابع') {
    $res = $conn->query("SELECT * FROM player_resources WHERE user_id=$user_id")->fetch_assoc();
    
    // محاسبه نرخ تولید
    $rates = calculatePlayerProduction($user_id);
    
    // محاسبه زمان باقیمانده تا نوبت بعدی
    $nextTurn = strtotime(date('Y-m-d') . ' ' . GAME_TURN_PROCESS_TIME);
    if (time() > $nextTurn) {
        $nextTurn = strtotime('+1 day ' . GAME_TURN_PROCESS_TIME);
    }
    $diff = $nextTurn - time();
    $hours = floor($diff / 3600);
    $minutes = floor(($diff % 3600) / 60);

    $msg = "📊 **گزارش دارایی‌های امپراتوری**\n\n";
    $msg .= "💰 **طلا:** " . number_format($res['gold']) . "\n";
    
    $msg .= "🌾 **غذا:** " . number_format($res['food']) . " ";
    $msg .= ($rates['food'] >= 0 ? "(+{$rates['food']}/روز)" : "") . "\n";
    
    $msg .= "🪵 **چوب:** " . number_format($res['wood']) . " ";
    $msg .= "(+{$rates['wood']}/روز)\n";
    
    $msg .= "🪨 **سنگ:** " . number_format($res['stone']) . " ";
    $msg .= "(+{$rates['stone']}/روز)\n\n";
    
    $msg .= "⏳ **نوبت بعدی:** $hours ساعت و $minutes دقیقه دیگر";
    
    sendMessage($chat_id, $msg);
}

// مسیریابی دکمه‌ها (Callback)
elseif (strpos($callback, 'map_') === 0) {
    $parts = explode('_', $callback);
    handleShowMap($user_id, $chat_id, $parts[1], $parts[2]);
    answerCallbackQuery($update['callback_query']['id']);
}
elseif (strpos($callback, 'tile_') === 0) {
    $parts = explode('_', $callback);
    handleTileSelect($user_id, $chat_id, $parts[1], $parts[2]); 
    answerCallbackQuery($update['callback_query']['id']);
}
elseif (strpos($callback, 'ask_move_') === 0) {
    $parts = explode('_', $callback);
    handleGeneralSelect($user_id, $chat_id, $parts[2], $parts[3]);
    answerCallbackQuery($update['callback_query']['id']);
}
elseif (strpos($callback, 'exec_move_') === 0) {
    $parts = explode('_', $callback);
    $msg = handleMoveOrder($user_id, $parts[2], $parts[3], $parts[4]);
    sendMessage($chat_id, $msg);
    answerCallbackQuery($update['callback_query']['id']);
}
// ارتش
elseif ($callback == 'army_menu') {
    handleArmyMenu($user_id, $chat_id);
    answerCallbackQuery($update['callback_query']['id']);
}
elseif (strpos($callback, 'gen_view_') === 0) {
    handleGeneralProfile($user_id, $chat_id, substr($callback, 9));
    answerCallbackQuery($update['callback_query']['id']);
}
elseif ($callback == 'gen_recruit') {
    sendMessage($chat_id, handleRecruitGeneral($user_id, $chat_id));
    handleArmyMenu($user_id, $chat_id);
    answerCallbackQuery($update['callback_query']['id']);
}
elseif ($callback == 'train_menu') {
    handleTrainMenu($user_id, $chat_id);
    answerCallbackQuery($update['callback_query']['id']);
}
elseif (strpos($callback, 'train_do_') === 0) {
    sendMessage($chat_id, handleTrainAction($user_id, substr($callback, 9)));
    answerCallbackQuery($update['callback_query']['id']);
}
// انتقال نیرو
elseif (strpos($callback, 'trans_sel_') === 0) {
    $parts = explode('_', $callback);
    handleTransferMenu($user_id, $chat_id, $parts[3], $parts[2]);
    answerCallbackQuery($update['callback_query']['id']);
}
elseif (strpos($callback, 'trans_qty_') === 0) {
    $parts = explode('_', $callback);
    handleTransferAmount($user_id, $chat_id, $parts[3], $parts[2], $parts[4]);
    answerCallbackQuery($update['callback_query']['id']);
}
elseif (strpos($callback, 'trans_do_') === 0) {
    $parts = explode('_', $callback);
    $msg = handleTransferExecute($user_id, $parts[3], $parts[2], $parts[4], $parts[5]);
    sendMessage($chat_id, $msg);
    handleGeneralProfile($user_id, $chat_id, $parts[3]);
    answerCallbackQuery($update['callback_query']['id']);
}
// شهر
elseif ($callback == 'city_menu') {
    handleCityMenu($user_id, $chat_id);
    answerCallbackQuery($update['callback_query']['id']);
}
elseif (strpos($callback, 'build_view_') === 0) {
    handleBuildView($user_id, $chat_id, substr($callback, 11));
    answerCallbackQuery($update['callback_query']['id']);
}
elseif (strpos($callback, 'build_start_') === 0) {
    $msg = handleBuildStart($user_id, substr($callback, 12));
    sendMessage($chat_id, $msg);
    if (strpos($msg, '✅') !== false) handleCityMenu($user_id, $chat_id);
    answerCallbackQuery($update['callback_query']['id']);
}
// جاسوسی
elseif (strpos($callback, 'spy_ask_') === 0) {
    $parts = explode('_', $callback);
    handleSpyMenu($user_id, $chat_id, $parts[2], $parts[3]);
    answerCallbackQuery($update['callback_query']['id']);
}
elseif (strpos($callback, 'spy_do_') === 0) {
    $parts = explode('_', $callback);
    $msg = handleSpyOrder($user_id, $parts[2], $parts[3], $parts[4]);
    sendMessage($chat_id, $msg);
    answerCallbackQuery($update['callback_query']['id']);
}
// دیپلماسی
elseif (strpos($callback, 'dip_req_') === 0) {
    $msg = handleSendDiplomacyRequest($user_id, substr($callback, 8));
    sendMessage($chat_id, $msg);
    answerCallbackQuery($update['callback_query']['id']);
}
elseif (strpos($callback, 'dip_acc_') === 0) {
    $msg = handleDiplomacyAction($user_id, substr($callback, 8), 'accept');
    sendMessage($chat_id, $msg);
    handleDiplomacyMenu($user_id, $chat_id); 
    answerCallbackQuery($update['callback_query']['id']);
}
elseif (strpos($callback, 'dip_rej_') === 0) {
    $msg = handleDiplomacyAction($user_id, substr($callback, 8), 'reject');
    sendMessage($chat_id, $msg);
    handleDiplomacyMenu($user_id, $chat_id);
    answerCallbackQuery($update['callback_query']['id']);
}
elseif (strpos($callback, 'dip_break_') === 0) {
    $msg = handleBreakAlliance($user_id, substr($callback, 10));
    sendMessage($chat_id, $msg);
    answerCallbackQuery($update['callback_query']['id']);
}
// رتبه‌بندی
elseif ($callback == 'show_ranking') {
    handleRanking($user_id, $chat_id);
    answerCallbackQuery($update['callback_query']['id']);
}

$conn->close();
?>