<?php
// Filename: cron/process_resources.php
require_once __DIR__ . '/../includes/db_connect.php';
require_once __DIR__ . '/../config.php';

echo "⏳ محاسبه تولید منابع (ساعتی)...\n";

$players = $conn->query("SELECT user_id FROM players");

while ($p = $players->fetch_assoc()) {
    $uid = $p['user_id'];
    
    // محاسبه سطح ساختمان‌ها
    $bRes = $conn->query("SELECT type, level FROM buildings WHERE user_id=$uid");
    $levels = [];
    while($b = $bRes->fetch_assoc()) $levels[$b['type']] = $b['level'];
    
    $farmLvl = $levels['farm'] ?? 0;
    $mineLvl = $levels['mine'] ?? 0;
    $lumberLvl = $levels['lumber'] ?? 0;
    
    // فرمول تولید
    $foodProd = ($farmLvl > 0) ? ($farmLvl * BUILDING_DATA['farm']['prod_rate']) : 10;
    $stoneProd = ($mineLvl > 0) ? ($mineLvl * BUILDING_DATA['mine']['prod_rate']) : 5;
    $woodProd = ($lumberLvl > 0) ? ($lumberLvl * BUILDING_DATA['lumber']['prod_rate']) : 10;

    // فقط اضافه کردن (بدون کسر)
    $conn->query("UPDATE player_resources SET 
                  food = food + $foodProd,
                  wood = wood + $woodProd,
                  stone = stone + $stoneProd,
                  last_update = NOW() 
                  WHERE user_id = $uid");
                  
    echo "User $uid: +$foodProd Food, +$woodProd Wood, +$stoneProd Stone\n";
}

echo "✅ انجام شد.";
?>