<?php
// Filename: cron/process_turn.php
// Description: موتور اصلی پردازش نوبت. هر شب توسط Cron Job اجرا می‌شود تا جنگ‌ها را محاسبه کند.

// فقط اجازه اجرا از طریق CLI (ترمینال) یا Cron را می‌دهد برای امنیت
if (php_sapi_name() !== 'cli') {
    // die("Access Denied"); // Uncomment for production
}

require_once __DIR__ . '/../includes/functions.php';

echo "شروع پردازش نوبت...\n";

// 1. دریافت تمام دستورات حرکت
$sql = "SELECT o.*, g.troops, g.user_id as owner_id 
        FROM turn_orders o 
        JOIN generals g ON o.general_id = g.id 
        ORDER BY o.created_at ASC";
$result = $conn->query($sql);

$movements = [];
// دسته‌بندی بر اساس مقصد (برای تشخیص درگیری چند ارتش در یک خانه)
while ($row = $result->fetch_assoc()) {
    $key = $row['target_x'] . '_' . $row['target_y'];
    $movements[$key][] = $row;
}

// 2. پردازش هر مقصد
foreach ($movements as $coord => $armies) {
    list($tx, $ty) = explode('_', $coord);
    
    if (count($armies) == 1) {
        // فقط یک ارتش به این خانه می‌رود
        processSingleArrival($armies[0], $tx, $ty);
    } else {
        // چند ارتش همزمان! (اینجا باید منطق Battle Royale باشد، فعلا ساده شده)
        echo "تداخل در مختصات $coord\n";
    }
}

// --- تابع پردازش ورود یک ارتش به یک خانه ---
function processSingleArrival($army, $x, $y) {
    global $conn;
    
    // بررسی اینکه در مقصد چه چیزی هست
    $stmt = $conn->prepare("SELECT * FROM map_tiles WHERE x = ? AND y = ?");
    $stmt->bind_param("ii", $x, $y);
    $stmt->execute();
    $tile = $stmt->get_result()->fetch_assoc();
    
    // حالت 1: خانه خالی یا متعلق به خودمان
    if (!$tile || !$tile['owner_id'] || $tile['owner_id'] == $army['owner_id']) {
        updateGeneralPos($army['general_id'], $x, $y);
        // اگر خانه خالی بود، تسخیر می‌شود
        if (!$tile['owner_id']) {
             $conn->query("INSERT INTO map_tiles (x, y, owner_id) VALUES ($x, $y, {$army['owner_id']}) ON DUPLICATE KEY UPDATE owner_id={$army['owner_id']}");
             sendMessage($army['owner_id'], "✅ ژنرال شما منطقه خالی ($x, $y) را تسخیر کرد.");
        } else {
             sendMessage($army['owner_id'], "✅ ژنرال به موقعیت ($x, $y) رسید.");
        }
        return;
    }
    
    // حالت 2: حمله به دشمن (محاسبه نبرد)
    $defenderTroops = json_decode($tile['garrison'], true) ?? [];
    $attackerTroops = json_decode($army['troops'], true) ?? [];
    
    $battleResult = calculateBattle($attackerTroops, $defenderTroops);
    
    if ($battleResult['winner'] == 'attacker') {
        // پیروزی مهاجم
        updateGeneralPos($army['general_id'], $x, $y);
        updateGeneralTroops($army['general_id'], $battleResult['attacker_survivors']);
        
        // تغییر مالکیت خانه
        $conn->query("UPDATE map_tiles SET owner_id = {$army['owner_id']}, garrison = NULL WHERE x=$x AND y=$y");
        
        sendMessage($army['owner_id'], "⚔️ پیروزی! شهر دشمن در ($x, $y) فتح شد.");
        sendMessage($tile['owner_id'], "🔥 شکست! شهر شما در ($x, $y) سقوط کرد.");
        
    } else {
        // پیروزی مدافع
        updateGeneralTroops($army['general_id'], $battleResult['attacker_survivors']);
        // ژنرال مهاجم به خانه قبلی برمی‌گردد (یا حذف می‌شود) - اینجا ساده‌سازی شده
        
        // بروزرسانی نیروهای باقیمانده مدافع
        $newGarrison = json_encode($battleResult['defender_survivors']);
        $conn->query("UPDATE map_tiles SET garrison = '$newGarrison' WHERE x=$x AND y=$y");
        
        sendMessage($army['owner_id'], "💀 حمله شکست خورد! ارتش شما عقب‌نشینی کرد.");
        sendMessage($tile['owner_id'], "🛡 دفاع موفقیت‌آمیز بود.");
    }
}

// تابع محاسبه ریاضی نبرد
function calculateBattle($attackers, $defenders) {
    $stats = UNIT_STATS;
    $bonuses = BATTLE_BONUSES;
    
    // 1. محاسبه قدرت حمله مهاجم
    $attPower = 0; $attHP = 0;
    foreach ($attackers as $type => $count) {
        $dmg = $stats[$type]['att'] * $count;
        $attHP += $stats[$type]['hp'] * $count;
        // اعمال بونوس علیه مدافع
        foreach ($defenders as $defType => $defCount) {
            if (isset($bonuses[$type][$defType])) $dmg *= $bonuses[$type][$defType];
        }
        $attPower += $dmg;
    }
    
    // 2. محاسبه قدرت مدافع
    $defPower = 0; $defHP = 0;
    foreach ($defenders as $type => $count) {
        $dmg = $stats[$type]['att'] * $count;
        $defHP += $stats[$type]['hp'] * $count;
        // بونوس دیوار شهر (فرضا 20%)
        $dmg *= 1.2; 
        $defPower += $dmg;
    }
    $defHP *= 1.2;

    // 3. محاسبه تلفات
    $attLossPct = ($attHP > 0) ? min(1, $defPower / $attHP) : 1;
    $defLossPct = ($defHP > 0) ? min(1, $attPower / $defHP) : 1;
    
    // 4. اعمال تلفات
    $attSurvivors = [];
    foreach ($attackers as $t => $c) $attSurvivors[$t] = floor($c * (1 - $attLossPct));
    
    $defSurvivors = [];
    foreach ($defenders as $t => $c) $defSurvivors[$t] = floor($c * (1 - $defLossPct));
    
    return [
        'winner' => ($attLossPct < $defLossPct) ? 'attacker' : 'defender',
        'attacker_survivors' => $attSurvivors,
        'defender_survivors' => $defSurvivors
    ];
}

// توابع کمکی دیتابیس
function updateGeneralPos($id, $x, $y) { global $conn; $conn->query("UPDATE generals SET x=$x, y=$y WHERE id=$id"); }
function updateGeneralTroops($id, $troops) { global $conn; $json = json_encode($troops); $conn->query("UPDATE generals SET troops='$json' WHERE id=$id"); }

// 3. پاکسازی
$conn->query("TRUNCATE TABLE turn_orders"); // پاک کردن دستورات انجام شده
$conn->query("UPDATE generals SET mp = max_mp"); // پر کردن MP برای فردا

echo "پایان پردازش نوبت.\n";
?>