<?php
// Filename: utils/map_gen.php
// Description: این فایل را اجرا کنید تا کل نقشه تبدیل به دشت (Plain) شود.
// اگر قبلاً کوه و جنگل ساخته‌اید، این اسکریپت آن‌ها را صاف می‌کند!

require_once __DIR__ . '/../includes/db_connect.php';
require_once __DIR__ . '/../config.php';

echo "<h2>🚜 در حال صاف کردن زمین و ایجاد دشت یکپارچه...</h2>";

$count = 0;

// استفاده از Transaction برای سرعت بالاتر
$conn->begin_transaction();

try {
    for ($x = 1; $x <= MAP_SIZE; $x++) {
        for ($y = 1; $y <= MAP_SIZE; $y++) {
            
            // فقط نوع 'plain' (دشت)
            $type = 'plain';
            
            // دستور SQL: اگر خانه وجود دارد، نوعش را به plain تغییر بده (UPDATE)
            // اما اگر قلعه (capital) است، به آن دست نزن تا پایتخت بازیکنان خراب نشود
            $sql = "INSERT INTO map_tiles (x, y, type) VALUES (?, ?, ?) 
                    ON DUPLICATE KEY UPDATE type = IF(type = 'capital', 'capital', VALUES(type))";
            
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("iis", $x, $y, $type);
            $stmt->execute();
            
            $count++;
        }
    }
    
    $conn->commit();
    echo "✅ انجام شد! $count خانه بررسی و صاف شد.<br>";
    echo "حالا تمام نقشه دشت است (هزینه حرکت: 1 MP).<br>";
    echo "<a href='../bot.php'>بازگشت به ربات (اگر وب‌هوک نیست)</a>";

} catch (Exception $e) {
    $conn->rollback();
    echo "❌ خطا: " . $e->getMessage();
}
?>