<?php
// Filename: utils/reset_game.php
// Description: این فایل تمام جداول بازی را خالی می‌کند تا بازی از صفر شروع شود.

require_once __DIR__ . '/../includes/db_connect.php';
require_once __DIR__ . '/../config.php';

// امنیت: فقط ادمین بتواند اجرا کند (یا روی لوکال هاست)
// اگر روی سرور عمومی هستید، بهتر است این فایل را رمزگذاری کنید یا بعد از استفاده حذف کنید.

echo "<h1>⚠️ در حال ریست کردن دنیای بازی...</h1>";

// غیرفعال کردن بررسی کلید خارجی
$conn->query("SET FOREIGN_KEY_CHECKS = 0");

$tables = [
    'espionage_missions',
    'diplomacy',
    'turn_orders',
    'building_queue',
    'buildings',
    'generals',
    'map_tiles',
    'player_resources',
    'players'
];

foreach ($tables as $table) {
    if ($conn->query("TRUNCATE TABLE `$table`")) {
        echo "✅ جدول <b>$table</b> پاکسازی شد.<br>";
    } else {
        echo "❌ خطا در پاکسازی $table: " . $conn->error . "<br>";
    }
}

// فعال کردن مجدد بررسی کلید خارجی
$conn->query("SET FOREIGN_KEY_CHECKS = 1");

echo "<hr>";
echo "<h3>🎉 دنیای بازی نابود شد و آماده خلق مجدد است!</h3>";
echo "<p>نکته: الان نقشه خالی است. برای ساخت دشت‌ها و کوه‌ها، فایل <a href='map_gen.php'>map_gen.php</a> را اجرا کنید.</p>";
echo "<a href='../bot.php'>بازگشت به ربات</a>";

?>